## 3a: Alternate method for estimating probability of homeownership

# Longitudinal panel HILDA data (rather than cross-sectional data across age groups) used to estimate probability of homeownership. 
## This resulted in younger cohorts taking longer to get into homeownership but overall higher homeownership rates by the 
## time cohorts reach age 50.


# Prelims -----------------------------------------------------------------

gc()


# Read in base params ---------------------------------------------

## starting cohort pathways (from step 3)
starting_cohorts_pathways <- qread(starting_cohorts_pathways_file)



# Read in alternate estimates of entry into housing probability -----------

## Calc'd the "Housing accumulation" R script in "Data and parameters" folder

housing_prob_adj <- qread("./Input data/housing_transition_probs_ai_alt.qs") %>% 
  rename(home_trans_prob_adj = home_trans_prob)



# Put into new version of starting_cohorts, convert to year list and save --------

starting_cohorts_pathways_adj <- starting_cohorts_pathways %>% 
  left_join(housing_prob_adj) %>% 
  ## replace values
  mutate( home_trans_prob = home_trans_prob_adj) %>% 
  select(-home_trans_prob_adj)



## split into list by year - save for use in model running
year_list_0 <- starting_cohorts_pathways_adj %>% 
  split(., .$year) 

qsave(year_list_0, "./Output data/year_list_0_alt_home_prob.qs")
